/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipe
extends AbstractModifierRecipe {
    private final class_1856 input;
    private final int amountPerInput;
    private final int neededPerLevel;
    private final class_1799 leftover;
    private List<List<class_1799>> slotCache;

    public IncrementalModifierRecipe(class_2960 id, class_1856 input, int amountPerInput, int neededPerLevel, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, class_1799 leftover, boolean allowCrystal) {
        super(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, allowCrystal);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
        ModifierRecipeLookup.setNeededPerLevel(result.getId(), neededPerLevel);
    }

    @Deprecated
    public IncrementalModifierRecipe(class_2960 id, class_1856 input, int amountPerInput, int neededPerLevel, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, class_1799 leftover) {
        this(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, leftover, true);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 level) {
        if (!this.result.isBound() || !this.toolRequirement.method_8093(inv.getTinkerableStack())) {
            return false;
        }
        return this.matchesCrystal(inv) || IncrementalModifierRecipe.containsOnlyIngredient(inv, this.input);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv, class_5455 registryAccess) {
        ValidatedResult commonError;
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ModifierId modifier = this.result.getId();
        int current = tool.getUpgrades().getLevel(modifier) == 0 ? this.neededPerLevel : IncrementalModifier.getAmount(tool, modifier);
        boolean crystal = this.matchesCrystal(inv);
        if ((crystal || current >= this.neededPerLevel) && (commonError = this.validatePrerequisites(tool)).hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.input, this.amountPerInput);
        if (crystal || current >= this.neededPerLevel) {
            SlotType.SlotCount slots = this.getSlots();
            if (slots != null) {
                persistentData.addSlots(slots.getType(), -slots.getCount());
            }
            int amount = crystal ? current : Math.min(available + current - this.neededPerLevel, this.neededPerLevel);
            IncrementalModifier.setAmount(persistentData, modifier, amount);
            tool.addModifier(this.result.getId(), this.result.getLevel());
        } else {
            IncrementalModifier.setAmount(persistentData, modifier, Math.min(current + available, this.neededPerLevel));
            tool.rebuildStats();
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        if (this.matchesCrystal(inv)) {
            super.updateInputs(result, inv, isServer);
            return;
        }
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        ModifierId modifier = this.result.getId();
        int needed = IncrementalModifier.getAmount(resultTool, modifier);
        int originalLevel = inputTool.getModifierLevel(modifier);
        needed = originalLevel > 0 ? (needed -= IncrementalModifier.getAmount(inputTool, modifier)) : (needed -= this.neededPerLevel);
        int levelChange = resultTool.getModifierLevel(modifier) - originalLevel;
        if (levelChange > 0) {
            needed += levelChange * this.neededPerLevel / this.result.getLevel();
        }
        if (needed > 0) {
            IncrementalModifierRecipe.updateInputs(inv, this.input, needed, this.amountPerInput, this.leftover);
        }
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.incrementalModifierSerializer.get();
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    private List<List<class_1799>> getInputs() {
        if (this.slotCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            List<class_1799> items = Arrays.asList(this.input.method_8105());
            int maxStackSize = items.stream().mapToInt(class_1799::method_7914).min().orElse(64);
            int needed = this.neededPerLevel / this.amountPerInput;
            if (this.neededPerLevel % this.amountPerInput > 0) {
                ++needed;
            }
            Lazy fullSize = Lazy.of(() -> items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)maxStackSize)).collect(Collectors.toList()));
            while (needed > maxStackSize) {
                builder.add((Object)((List)fullSize.get()));
                needed -= maxStackSize;
            }
            if (needed > 0) {
                int remaining = needed;
                builder.add(items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)remaining)).collect(Collectors.toList()));
            }
            this.slotCache = builder.build();
        }
        return this.slotCache;
    }

    @Override
    public int getInputCount() {
        return this.getInputs().size();
    }

    @Override
    public List<class_1799> getDisplayItems(int slot) {
        List<List<class_1799>> inputs = this.getInputs();
        if (slot >= 0 && slot < inputs.size()) {
            return inputs.get(slot);
        }
        return Collections.emptyList();
    }

    public static boolean containsOnlyIngredient(ITinkerableContainer inv, class_1856 ingredient) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960()) continue;
            if (ingredient.method_8093(stack)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public static int getAvailableAmount(ITinkerStationContainer inv, class_1856 ingredient, int amountPerItem) {
        int available = 0;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960() || !ingredient.method_8093(stack)) continue;
            available += stack.method_7947() * amountPerItem;
        }
        return available;
    }

    public static void updateInputs(IMutableTinkerStationContainer inv, class_1856 ingredient, int amountNeeded, int amountPerInput, class_1799 leftover) {
        int itemsNeeded = amountNeeded / amountPerInput;
        int leftoverAmount = amountNeeded % amountPerInput;
        if (leftoverAmount > 0) {
            ++itemsNeeded;
            if (!leftover.method_7960()) {
                inv.giveItem(ItemHandlerHelper.copyStackWithSize((class_1799)leftover, (int)(leftoverAmount * leftover.method_7947())));
            }
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960() || !ingredient.method_8093(stack)) continue;
            int count = stack.method_7947();
            if (count > itemsNeeded) {
                inv.shrinkInput(i, itemsNeeded);
                break;
            }
            inv.shrinkInput(i, count);
            itemsNeeded -= count;
        }
    }

    @Deprecated
    public static class_1799 deseralizeResultItem(JsonObject parent, String name) {
        return JsonUtils.getAsItemStack(parent, name);
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<IncrementalModifierRecipe> {
        @Override
        public IncrementalModifierRecipe fromJson(class_2960 id, JsonObject json, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            class_1856 input = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"input"));
            int amountPerInput = class_3518.method_15282((JsonObject)json, (String)"amount_per_item", (int)1);
            if (amountPerInput < 1) {
                throw new JsonSyntaxException("amount_per_item must be positive");
            }
            int neededPerLevel = class_3518.method_15260((JsonObject)json, (String)"needed_per_level");
            if (neededPerLevel <= amountPerInput) {
                throw new JsonSyntaxException("needed_per_level must be greater than amount_per_item");
            }
            class_1799 leftover = class_1799.field_8037;
            if (amountPerInput > 1 && json.has("leftover")) {
                leftover = IncrementalModifierRecipe.deseralizeResultItem(json, "leftover");
            }
            boolean allowCrystal = class_3518.method_15258((JsonObject)json, (String)"allow_crystal", (boolean)true);
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, leftover, allowCrystal);
        }

        @Override
        public IncrementalModifierRecipe fromNetwork(class_2960 id, class_2540 buffer, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            int amountPerInput = buffer.method_10816();
            int neededPerLevel = buffer.method_10816();
            class_1799 leftover = buffer.method_10819();
            boolean allowCrystal = buffer.readBoolean();
            return new IncrementalModifierRecipe(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, leftover, allowCrystal);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, IncrementalModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            recipe.input.method_8088(buffer);
            buffer.method_10804(recipe.amountPerInput);
            buffer.method_10804(recipe.neededPerLevel);
            buffer.method_10793(recipe.leftover);
            buffer.writeBoolean(recipe.allowCrystal);
        }
    }
}

